/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mlib.data.IReader;
import com.mlib.data.ISerializable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

record DataObject<Type>(Supplier<Type> getter, Consumer<Type> setter, IReader<Type> reader, String key) implements ISerializable
{
    @Override
    public void read(JsonElement element) {
        JsonObject object = element.getAsJsonObject();
        if (object.has(this.key)) {
            this.setter.accept(this.reader.read(object.get(this.key)));
        }
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        this.reader.write(buffer, this.getter.get());
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.setter.accept(this.reader.read(buffer));
    }

    @Override
    public void write(Tag tag) {
        if (this.getter.get() == null) {
            return;
        }
        CompoundTag compoundTag = (CompoundTag)tag;
        compoundTag.m_128365_(this.key, this.reader.write(this.getter.get()));
    }

    @Override
    public void read(Tag tag) {
        CompoundTag compoundTag = (CompoundTag)tag;
        if (compoundTag.m_128441_(this.key)) {
            this.setter.accept(this.reader.read(compoundTag.m_128423_(this.key)));
        }
    }

    public static interface Setter<Type>
    extends Consumer<Type> {
    }

    public static interface Getter<Type>
    extends Supplier<Type> {
    }
}

